import socket
import threading
import tkinter as tk
from tkinter import scrolledtext, simpledialog
import datetime
import winsound  # Ses için

class RanaMessenger:
    def __init__(self, root):
        self.root = root
        self.root.title("Rana Bilgisayar - www.ranabilgisayar.com")
        self.root.geometry("500x600")
        
        # Kullanıcı Adı Al
        self.username = simpledialog.askstring("Giriş", "Kullanıcı adınızı girin:", parent=self.root)
        if not self.username: self.username = "Anonim"

        # Arayüz Elemanları
        self.chat_area = scrolledtext.ScrolledText(root, state='disabled', wrap=tk.WORD, font=("Segoe UI", 10))
        self.chat_area.pack(padx=10, pady=10, fill=tk.BOTH, expand=True)

        self.msg_entry = tk.Entry(root, font=("Segoe UI", 12))
        self.msg_entry.pack(padx=10, pady=5, fill=tk.X)
        self.msg_entry.bind("<Return>", lambda event: self.send_message())

        # Fokus (Odak) Takibi: Uygulamaya bakılıyor mu?
        self.is_focused = True
        self.root.bind("<FocusIn>", self.on_focus_in)
        self.root.bind("<FocusOut>", self.on_focus_out)

        # Ağ Ayarları
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
        try: self.sock.bind(('', 12345))
        except: pass

        threading.Thread(target=self.receive_messages, daemon=True).start()

    def on_focus_in(self, event):
        self.is_focused = True
        self.root.title("Rana Bilgisayar - www.ranabilgisayar.com")
        self.chat_area.config(bg="white") # Okunanca rengi düzelt

    def on_focus_out(self, event):
        self.is_focused = False

    def send_message(self):
        msg = self.msg_entry.get()
        if msg:
            full_msg = f"{self.username}: {msg}"
            self.sock.sendto(full_msg.encode('utf-8'), ('255.255.255.255', 12345))
            self.display_message(f"Siz: {msg}")
            self.save_to_history(f"Siz: {msg}")
            self.msg_entry.delete(0, tk.END)

    def receive_messages(self):
        while True:
            try:
                data, addr = self.sock.recvfrom(1024)
                decoded_msg = data.decode('utf-8')
                if not decoded_msg.startswith(f"{self.username}:"):
                    self.display_message(decoded_msg)
                    self.save_to_history(decoded_msg)
                    self.notify_user()
            except: break

    def notify_user(self):
        # Ses çal
        winsound.Beep(1000, 200) 
        
        if not self.is_focused:
            # Arka plandaysa başlığı değiştir ve yanıp sönme efekti yap
            self.root.title("!!! YENİ MESAJ VAR !!!")
            self.chat_area.config(bg="#fff3cd") # Hafif sarı renk (dikkat çekici)
            # Görev çubuğunda yanıp sönme (Windows için)
            self.root.wm_attributes("-topmost", 1)
            self.root.wm_attributes("-topmost", 0)

    def save_to_history(self, msg):
        now = datetime.datetime.now().strftime("%Y-%m-%d %H:%M")
        with open("mesaj_gecmisi.txt", "a", encoding="utf-8") as f:
            f.write(f"[{now}] {msg}\n")

    def display_message(self, msg):
        self.chat_area.config(state='normal')
        self.chat_area.insert(tk.END, msg + "\n")
        self.chat_area.config(state='disabled')
        self.chat_area.yview(tk.END)

if __name__ == "__main__":
    root = tk.Tk()
    app = RanaMessenger(root)
    root.mainloop()